/*
 * Decompiled with CFR 0.152.
 */
package MailingSystem;

import MailingSystem.MailingSystem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import net.risingworld.api.database.Database;

public class DatabaseStuff {
    public static Database data;
    public MailingSystem MS = new MailingSystem();

    public void setDB(Database db) {
        data = db;
    }

    public void initDB() {
        data.execute("CREATE TABLE IF NOT EXISTS 'Messages' ('SenderName' VARCHAR(64), 'ReceiverName' VARCHAR(64), 'Message' VARCHAR(1000), 'Timestamp' TIMESTAMP)");
    }

    public ArrayList<mail> getMail(String name) {
        ArrayList<mail> messages = new ArrayList<mail>();
        Connection con = data.getConnection();
        try {
            PreparedStatement prep = con.prepareStatement("SELECT * FROM Messages WHERE ReceiverName LIKE ?");
            prep.setString(1, name);
            ResultSet result = prep.executeQuery();
            while (result.next()) {
                mail m = new mail();
                m.SenderName = result.getString("SenderName");
                m.ReceiverName = result.getString("ReceiverName");
                m.Message = result.getString("Message");
                m.timestamp = result.getTimestamp("Timestamp");
                messages.add(m);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return messages;
    }

    public void sendMail(String senderName, String receiverName, String message) {
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        Connection con = data.getConnection();
        try {
            PreparedStatement prep = con.prepareStatement("INSERT INTO Messages (SenderName, ReceiverName, Message, Timestamp) VALUES (?,?,?,?)");
            prep.setString(1, senderName);
            prep.setString(2, receiverName);
            prep.setString(3, message);
            prep.setTimestamp(4, timestamp);
            prep.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void clearMail(String name) {
        Connection con = data.getConnection();
        try {
            PreparedStatement prep = con.prepareStatement("DELETE FROM Messages WHERE ReceiverName LIKE ?");
            prep.setString(1, name);
            prep.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void monthlyClear() {
        try (ResultSet result = data.executeQuery("SELECT * FROM Messages");){
            while (result.next()) {
                Timestamp olddate = result.getTimestamp("Timestamp");
                Date date = new Date();
                long difference = (date.getTime() - olddate.getTime()) / 86400000L;
                if (difference < (long)Integer.parseInt(this.MS.SettingbyName("MailDeletionPeriod"))) continue;
                result.deleteRow();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public class mail {
        String SenderName;
        String ReceiverName;
        String Message;
        Timestamp timestamp;
    }
}

