////////////////////////////////////////////////////////////////////////////////////
/////    Water-Material Shader for water/fluids                                /////
/////    Based on Michael Horsch water: http://www.bonzaisoftware.com/wfs.html /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef FOG
    #import "Shaders/Lib/Fog.glsllib"
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_WorldMatrix;

uniform float m_Time;

attribute vec3 inPosition;
attribute vec3 inNormal;
attribute vec4 inColor;
attribute vec2 inTexCoord;

varying vec4 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec2 texCoord;
varying vec4 fog;

varying vec2 watertex1;
varying vec2 watertex2;
varying float fade;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    position = gl_Position;
    worldpos = vec3(g_WorldMatrix * pos);
    normal = inNormal * 0.01;
    texCoord = worldpos.xz;
    
    vec4 viewpos = g_WorldViewMatrix * pos;
    fade = 1.0 - smoothstep(0.0, 6.0, length(viewpos.xyz));

    #ifdef FOG
        calculateFog(vec4(g_WorldViewMatrix * pos), fog);
    #endif

    vec2 t = vec2(0.0, m_Time);
    watertex1 = texCoord.xy * 0.01 + t;
    watertex2 = texCoord.xy * 0.01 - t;
    
}