////////////////////////////////////////////////////////////////////////////////////
/////    Water-Material Shader for water/fluids                                /////
/////    Based on Michael Horsch water: http://www.bonzaisoftware.com/wfs.html /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#import "Shaders/Lib/Selector.glsllib"

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform mat4 g_ViewProjectionMatrixInverse;

uniform sampler2D m_WaterTexture;

uniform sampler2D m_DUDVTexture;
uniform sampler2D m_ReflectionTexture;

uniform bool m_Underwater;

uniform float m_TextureScale;
uniform float m_DistortionScale;
uniform float m_DistortionMix;
uniform float m_WaterTransparency;

uniform float m_DayNightTime;

varying vec4 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec2 texCoord;
varying vec4 fog;

varying vec2 watertex1;
varying vec2 watertex2;
varying float fade;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const vec4 waterColor = vec4(0.1843, 0.2588, 0.4471, 1.0);

void main(){
    vec4 dist1 = texture2D(m_DUDVTexture, watertex1 * m_TextureScale);
    vec4 distortion = texture2D(m_DUDVTexture, watertex2 + vec2(dist1) * m_DistortionMix);
    distortion = normalize(distortion * 2.0 - 1.0) * m_DistortionScale;

    //Get projective texcoords
    vec4 projCoord = position / position.w;
    projCoord = (projCoord + 1.0) * 0.5 + distortion;
    projCoord = clamp(projCoord, 0.001, 0.999);

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif

    //Falls Unterwasser (Farbe der Wasseroberfläche)
    if(m_Underwater){
        #ifndef REFRACTION
            gl_FragColor = vec4(0.0235, 0.32157, 0.65882, 0.5);//texture2D(m_WaterTexture, projCoord.xy);
            return;
        #else
            gl_FragColor = vec4(0.0235, 0.32157, 0.65882, 0.2);//texture2D(m_WaterTexture, projCoord.xy);
            return;
        #endif
    }

    //Water texture (default texture)
    vec4 fragColor = texture2D(m_WaterTexture, projCoord.xy);
    fragColor.rgb *= 0.1 + (m_DayNightTime - 0.1);

    //Reflection
    #ifdef REFLECTION
        vec4 reflection = texture2D(m_ReflectionTexture, vec2(projCoord.x, 1.0 - projCoord.y));
        fragColor = mix(fragColor, reflection, 0.05 + (0.45 * (1.0 - fade)));
    #endif
    
    //Fog
    #ifdef FOG
        fragColor.rgb = mix(fog.rgb, fragColor.rgb, fog.w);
    #endif
    
    //Selector
    #ifdef SELECTOR
        calculateSelector(worldpos, fragColor);
    #endif
    
    fragColor.a = 1.0; //m_WaterTransparency;
    
    gl_FragColor = fragColor;
    //gl_FragColor.a = 0.6 * (1.0 - fade) + 0.15;
}