////////////////////////////////////////////////////////////////////////////////////
/////    Vegetation-Material Shader for foliage (trees etc) influenced by wind /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#extension GL_EXT_gpu_shader4 : enable
#extension GL_EXT_texture_array : enable

#import "Shaders/Lib/Selector.glsllib"

#ifndef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform vec3 g_CameraDirection;
uniform vec3 g_CameraPosition;

uniform sampler2DArray m_Textures_Array_Bark;
uniform sampler2DArray m_Textures_Array_Leaves;
uniform sampler2DArray m_Textures_Array_Fruit;
uniform sampler2DArray m_Textures_Array_Plant;
uniform sampler2DArray m_Textures_Array_Snow;

uniform bool m_PickingActive;
uniform vec4 m_PickingPosition;

varying vec3 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 light;
varying vec4 texCoord;  //X=TexCoordx, Y=TexCoordy, Z=TextureLayer, W=0 (Log) or 1 (Leaves)
varying vec2 texCoord2;
varying vec4 fog;
varying float fade;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    #ifdef TEXTURES
        vec4 fragColor = vec4(1.0, 0.0, 0.0, 1.0);
        float snowadjustment = 0.0;
        
        //Barktexture
        if(texCoord.w <= 0.5){
            fragColor = texture2DArray(m_Textures_Array_Bark, texCoord.xyz);
            snowadjustment = 1.0;
        }
        //Leavestexture
        else if(texCoord.w <= 1.5){
            fragColor = texture2DArray(m_Textures_Array_Leaves, texCoord.xyz);
        }
        //Fruittexture
        else if(texCoord.w <= 2.5){
            fragColor = texture2DArray(m_Textures_Array_Fruit, texCoord.xyz);
        }
        //Planttexture
        else if(texCoord.w <= 3.5){
            fragColor = texture2DArray(m_Textures_Array_Plant, texCoord.xyz);
        }

        //Snow
        #ifdef SNOWTEXTURES
            //Alphadiscarding
            if(fragColor.a <= (0.5 - (step(0.5, texCoord2.x) * 0.25))){
                discard;
            }
            if(texCoord2.x > 0.5){
                vec4 snow = texture2DArray(m_Textures_Array_Snow, vec3(texCoord.x, texCoord.y, max(0.0, texCoord2.x - 1.0 - snowadjustment)));
                snow.rgb *= 1.5;
                fragColor.rgb = mix(fragColor.rgb, snow.rgb, snow.a);
            }
        #else
            //Alphadiscarding
            if(fragColor.a <= 0.5){
                discard;
            }
        #endif
    #else
        vec4 fragColor = vec4(1.0, 0.0, 0.0, 1.0);
    #endif

    //If normal-quality light is enabled: Per-Pixel-Lighting calculation (dynamic Spotlights)
    #ifndef VERTEXLIGHTING
        fragColor.rgb *= calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #else
        fragColor.rgb *= light;
    #endif
    
    #ifdef FOG
        fragColor.rgb = mix(fog.rgb, fragColor.rgb, fog.w);
    #endif
    
    #ifdef SELECTOR
        calculateSelector(worldpos, fragColor);
    #endif
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}