////////////////////////////////////////////////////////////////////////////////////
/////    Sky Shader for daytime-dependent sky                                  /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

uniform sampler2D m_NightTexture;
uniform sampler2D m_NightFlareTexture;
uniform sampler2D m_MoonTexture;
uniform sampler2D m_CloudTexture;
uniform sampler2D m_CloudTexture2;

uniform float m_Cloudiness;

uniform vec3 m_SunPosition;
uniform vec3 m_MoonPosition;

uniform float m_DayNightTime;  //Range 0 - 1

varying vec3 position;
varying vec2 texCoord;
varying vec2 cloudCoord;
varying vec2 cloudCoord2;
varying float border;  //Range -1 - 200
varying vec4 overlayFog;
varying vec4 fog;
varying float flicker;
varying float cloudalpha;
varying float overclouds;

const vec3 sunColor = vec3(1.0, 1.0, 0.95);
const vec3 cloudDayColor = vec3(0.95, 0.95, 0.95);
const vec3 cloudNightColor = vec3(0.03, 0.05, 0.08);
const vec3 daySkyColor = vec3(0.45, 0.592, 1.0);
const vec3 overcastDaySkyColor = vec3(0.4, 0.4, 0.4);
const vec3 overcastNightSkyColor = vec3(0.0, 0.0, 0.0);

//const vec3 daysky = vec3(0.6, 0.698, 0.949);
//const vec3 daysky = vec3(0.2, 0.3, 0.5);

void main(){
    vec4 fragColor = vec4(1.0);

    #if defined(MOON)

        fragColor = texture2D(m_MoonTexture, texCoord);
        fragColor.a *= (1.0 - m_DayNightTime) * smoothstep(5.0, 25.0, position.y);

    #elif defined(CLOUDTEXTURE)

        //Blend between day- and nightsky
        fragColor.rgb = mix(vec3(0.0), vec3(1.0), m_DayNightTime);

        float cloudiness1 = smoothstep(0.0, 1.0, m_Cloudiness);  //Regular clouds
        float cloudiness2 = smoothstep(1.0, 2.0, m_Cloudiness);  //Overcast clouds
        float fadefactor = smoothstep(0.0, 60.0, position.y) * cloudalpha;
        float cloud1 = texture2D(m_CloudTexture, cloudCoord).r * fadefactor * cloudiness1;
        float cloud2 = texture2D(m_CloudTexture, cloudCoord2).r * fadefactor * cloudiness1;
        float cloud3 = texture2D(m_CloudTexture2, cloudCoord).r * fadefactor * cloudiness2;
        float cloud4 = texture2D(m_CloudTexture2, cloudCoord2).r * fadefactor * cloudiness2;
        
        vec3 cloudColor = mix(cloudNightColor, cloudDayColor, m_DayNightTime) * (1.0 - (cloudiness2 * 0.5));
        
        fragColor.a = max(max(max(cloud1, cloud2), cloud3), cloud4);
        fragColor.rgb = mix(fragColor.rgb, cloudColor, cloud1);
        fragColor.rgb = mix(fragColor.rgb, cloudColor, cloud2);
        fragColor.rgb = mix(fragColor.rgb, cloudColor, cloud3);
        //fragColor.rgb = mix(fragColor.rgb, cloudColor, min(cloud1*2.0, 1.0));
        //fragColor.rgb = mix(fragColor.rgb, cloudColor, min(cloud2*2.0, 1.0));
        
        vec4 overlayColor = vec4(0.79999995, 0.6999999, 0.49999988, 1.0);
        overlayColor.rgb *= m_DayNightTime;
        overlayColor.a = cloudalpha;
        //fragColor = overlayColor;
        
    #else

        #if defined(NIGHTTEXTURE)
            vec3 nightsky = texture2D(m_NightTexture, texCoord * 5.0).rgb;
            nightsky.rgb *= flicker;
            
            //Moon
            float distToMoon = distance(position.xyz, m_MoonPosition.xyz);
            nightsky.rgb *= step(11.75, distToMoon);
            nightsky.rgb = mix(nightsky.rgb, vec3(0.9216, 0.8392, 0.6706), ((1.0 - smoothstep(-50.0, 60.0, distToMoon)) * 0.7 * (1.0 - smoothstep(0.2, 0.7, m_DayNightTime))));
        #else
            vec3 nightsky = vec3(0.0, 0.0, 0.0);
        #endif

        //Sky Color
        float cloudiness = smoothstep(1.0, 2.0, m_Cloudiness) * (1.0 - overclouds);
        vec3 daysky = mix(daySkyColor, overcastDaySkyColor, cloudiness);
        nightsky *= (1.0 - cloudiness);

        //Blend between day and night sky
        fragColor.rgb = mix(nightsky, daysky, m_DayNightTime);

        vec3 finalSunColor = sunColor;

        #if defined(FOG)
            fragColor.rgb = mix(fragColor.rgb, fog.rgb, 1.0 - smoothstep(0.0, 60.0, position.y));
            finalSunColor = mix(sunColor, fog.rgb, 1.0 - smoothstep(0.0, 0.15, m_DayNightTime));
        #endif

        //Sun
        float distToSun = distance(position.xyz, m_SunPosition.xyz) + (7.0 * (1.0 - smoothstep(-11.0, 0.0, m_SunPosition.y)));
        fragColor.rgb = mix(finalSunColor, fragColor.rgb, max(smoothstep(-10.0, 50.0, distToSun) - (1.0 - step(3.5, distToSun)), 0.0));
    
    #endif

    #if defined(FOG)
        //Fog Border
        fragColor.rgb = mix(fog.rgb, fragColor.rgb, smoothstep(border-4.0, border+4.0, position.y));
    #else
        //Black Color
        fragColor.rgb *= smoothstep(border-4.0, border+4.0, position.y);
    #endif

    fragColor = mix(fragColor, overlayFog, overlayFog.a);
    
    gl_FragColor = fragColor;  

    #if defined(LOGARITHMIC_DEPTH_BUFFER)
        gl_FragDepth = 1.0;
    #endif
}