////////////////////////////////////////////////////////////////////////////////////
/////    Water Refraction Shader to calculate water refractions                /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform float m_Time;

attribute vec3 inPosition;

varying vec2 watertex1;
varying vec2 watertex2;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    vec2 texCoord = vec3(g_WorldMatrix * pos).xz;

    vec2 tex1 = vec2(0.0, -m_Time);
    vec2 tex2 = vec2(0.0, m_Time);

    watertex1 = texCoord.xy * 0.01 + tex1;
    watertex2 = texCoord.xy * 0.01 + tex2;
}