////////////////////////////////////////////////////////////////////////////////////
/////    Refraction Shader for refracted Objects like glass                    /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_WorldMatrix;

uniform vec4 m_Fog;

attribute vec3 inPosition;
attribute vec2 inTexCoord;
attribute vec3 inColor;

varying vec3 position;
varying vec3 worldpos;
varying vec3 color;
varying vec2 texCoord;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    #ifdef FOG
        vec4 viewpos = g_WorldViewMatrix * pos;
        float dist = length(viewpos.xyz);
        fog = m_Fog;
        fog.w = exp2(-m_Fog.w * m_Fog.w * dist * dist * 1.442695);
        fog.w = clamp(fog.w, 0.0, 1.0);
    #endif
    
    position = inPosition;
    worldpos = vec3(g_WorldMatrix * pos);
    texCoord = inTexCoord;
    
    #ifdef VERTEXCOLOR
        color = inColor;
    #endif
}