////////////////////////////////////////////////////////////////////////////////////
/////    Refraction Shader for refracted Objects like glass                    /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform sampler2D m_Texture;
uniform vec4 m_Color;

varying vec3 position;
varying vec3 worldpos;
varying vec3 color;
varying vec2 texCoord;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    #ifdef TEXTURE
        vec4 fragColor = texture2D(m_Texture, texCoord);
        #ifdef COLOR
            fragColor = mix(m_Texture, m_Color, 0.5);
        #endif
        fragColor.a = 0.6;
    #else
        #ifdef COLOR
            vec4 fragColor = m_Color;
        #else
            vec4 fragColor = vec4(1.0);
        #endif
    #endif
    
    #ifdef FOG
        fragColor.xyz = mix(fog.xyz, fragColor.xyz, fog.w);
    #endif

    #ifdef VERTEXCOLOR
        fragColor.xyz += color;
    #endif
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}