////////////////////////////////////////////////////////////////////////////////////
/////    PreNormalShader for calculating normals for SSAO                      /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#if defined(INSTANCING)
    #import "Shaders/Lib/Instancing.glsllib"
#else
    uniform mat4 g_WorldViewProjectionMatrix;
    uniform mat4 g_WorldMatrix;
#endif

uniform mat3 g_NormalMatrix;

attribute vec3 inPosition;
attribute vec3 inNormal;

#if defined(GRASS)
    attribute vec3 inTexCoord;
    varying vec3 texCoord;
    #if defined(OCCLUSION)
        varying vec3 worldpos;
    #endif
#elif defined(VEGETATION)
    attribute vec4 inTexCoord;
    varying vec4 texCoord;
#elif defined(OBJECT)
    attribute vec4 inTexCoord;
    varying vec4 texCoord;
#elif defined(ALPHATEXTURE)
    attribute vec2 inTexCoord;
    varying vec2 texCoord;
#endif

varying vec3 normal;

#if defined(LOGARITHMIC_DEPTH_BUFFER)
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    
    #if defined(INSTANCING)
        gl_Position = transformWorldViewProjection(pos);
    #else
        gl_Position = g_WorldViewProjectionMatrix * pos;
    #endif

    #if defined(LOGARITHMIC_DEPTH_BUFFER)
        positionProjectionSpace = gl_Position;
    #endif
    
    normal = normalize(g_NormalMatrix * inNormal.xyz);

    #if defined(GRASS) || defined(VEGETATION) || defined(OBJECT) || defined(ALPHATEXTURE)
        texCoord = inTexCoord;
        #if defined(OCCLUSION)
            worldpos = vec3(g_WorldMatrix * pos);
        #endif
    #endif
}