////////////////////////////////////////////////////////////////////////////////////
/////    PreNormalShader for calculating normals for SSAO                      /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#if defined(GRASS)
    #extension GL_EXT_gpu_shader4 : enable
    #extension GL_EXT_texture_array : enable

    #if defined(OCCLUSION)
        #import "Shaders/Lib/Grassocclusion.glsllib"
    #endif
    uniform sampler2DArray m_Textures_Array;
    varying vec3 texCoord;
    varying vec3 worldpos;
#elif defined(VEGETATION)
    #extension GL_EXT_gpu_shader4 : enable
    #extension GL_EXT_texture_array : enable

    uniform sampler2DArray m_Textures_Array_Leaves;
    varying vec4 texCoord;
#elif defined(OBJECT)
    #extension GL_EXT_gpu_shader4 : enable
    #extension GL_EXT_texture_array : enable

    uniform sampler2DArray m_AlphaTextures_Array;
    varying vec4 texCoord;
#elif defined(ALPHATEXTURE)
    uniform sampler2D m_Texture;
    varying vec2 texCoord;
#endif

#if defined(LOGARITHMIC_DEPTH_BUFFER)
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

varying vec3 normal;

#if defined(LOGARITHMIC_DEPTH_BUFFER)
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 fragColor = vec4(normal.xy * 0.5 + 0.5, -normal.z * 0.5 + 0.5, 1.0);
    
    #if defined(GRASS)
        if(texture2DArray(m_Textures_Array, texCoord).a < 0.75){
            discard;
        }
        #if defined(OCCLUSION)
            vec2 occTexCoord = getOccludeTexCoord(worldpos);
            if((occTexCoord.x > 0.0) && (occTexCoord.x < 1.0) && (occTexCoord.y > 0.0) && (occTexCoord.y < 1.0)){
                float depth = texture2D(m_OccludeDepthTexture, occTexCoord).r;
                float occludePosition = getOcclusionPosition(depth, occTexCoord).y;
                if(worldpos.y > occludePosition){
                    discard;
                }
            }
        #endif
        fragColor = vec4(1.0);
    #elif defined(VEGETATION)
        //Leavetexture Alphadiscard
        if(texCoord.w >= 0.5){
            if(texture2DArray(m_Textures_Array_Leaves, texCoord.xyz).a < 0.9){
                discard;
            }
        }
    #elif defined(OBJECT)
        //Masked texture Alphadiscard
        if(texCoord.w >= 0.5){
            discard;
        }
    #elif defined(ALPHATEXTURE)
        if(texture2D(m_Texture, texCoord).a < 0.7){
            discard;
        }
    #elif defined(NOSSAO)
        fragColor = vec4(0.5);
    #endif
    
    gl_FragColor = fragColor;

    #if defined(LOGARITHMIC_DEPTH_BUFFER)
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}