////////////////////////////////////////////////////////////////////////////////////
/////    SSAOFilter Blur Shader (Post Processing)                              /////
/////    Based on JMonkey/ShaderBlow SSAO Filter                               /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

uniform vec2 g_Resolution;

uniform sampler2D m_Texture;
uniform sampler2D m_SSAOMap;

varying vec2 texCoord;

float random(in vec4 seed){
    float dot_product = dot(seed, vec4(12.9898, 78.233, 45.164, 94.673));
    return fract(sin(dot_product) * 43758.5453);
}

void main(){
    vec4 ssao = vec4(0.0);
    
    for(int i = 0; i < 4; i++){
        ssao += texture2D(m_SSAOMap, texCoord + (random(vec4(texCoord, -texCoord) * vec4(float(-i))) / 200.0));
        #ifdef EXTRASMOOTH 
            ssao += texture2D(m_SSAOMap, texCoord + (random(vec4(-texCoord, texCoord) * vec4(float(i))) / 100.0));
        #endif
    }

    #ifdef EXTRASMOOTH
        ssao /= 8.0;
    #else
        ssao /= 4.0;
    #endif

    gl_FragColor = texture2D(m_Texture, texCoord) * ssao;
}