////////////////////////////////////////////////////////////////////////////////////
/////    MotionBlur Shader (Post Processing)                                   /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifndef NUMMOTIONSTEPS
    #define NUMMOTIONSTEPS 0
#endif

uniform sampler2D m_Texture;

#if NUMMOTIONSTEPS >= 1
    uniform sampler2D m_MotionTexture1;
#endif
#if NUMMOTIONSTEPS >= 2
    uniform sampler2D m_MotionTexture2;
#endif
#if NUMMOTIONSTEPS >= 3
    uniform sampler2D m_MotionTexture3;
#endif
#if NUMMOTIONSTEPS >= 4
    uniform sampler2D m_MotionTexture4;
#endif
#if NUMMOTIONSTEPS >= 5
    uniform sampler2D m_MotionTexture5;
#endif

uniform float m_Intensity;

varying vec2 texCoord;

void main(){
    vec4 fragColor = texture2D(m_Texture, texCoord);

    #if NUMMOTIONSTEPS >= 1
        fragColor = mix(fragColor, texture2D(m_MotionTexture1, texCoord), 0.2);
    #endif
    #if NUMMOTIONSTEPS >= 2
        fragColor = mix(fragColor, texture2D(m_MotionTexture2, texCoord), 0.175);
    #endif
    #if NUMMOTIONSTEPS >= 3
        fragColor = mix(fragColor, texture2D(m_MotionTexture3, texCoord), 0.15);
    #endif
    #if NUMMOTIONSTEPS >= 4
        fragColor = mix(fragColor, texture2D(m_MotionTexture4, texCoord), 0.175);
    #endif
    #if NUMMOTIONSTEPS >= 5
        fragColor = mix(fragColor, texture2D(m_MotionTexture5, texCoord), 0.1);
    #endif
    
    gl_FragColor = fragColor;
}
