////////////////////////////////////////////////////////////////////////////////////
/////    LightScattering / God Rays Shader (Post Processing)                   /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform sampler2D m_Texture;
uniform sampler2D m_DepthTexture;

uniform int m_LSSamples;
uniform bool m_LSActive;
uniform float m_LSDensity;
uniform vec3 m_LSPosition;
uniform vec2 m_LSBlur;

varying vec2 texCoord;

void main(){
    vec4 fragColor = texture2D(m_Texture, texCoord);
    
    if(m_LSActive){
        float factor = (m_LSBlur.y / (float(m_LSSamples) - 1.0));
        vec2 scaledTexCoord;
        vec2 newTexCoord = texCoord - m_LSPosition.xy;
        vec4 sum = vec4(0.0);
        for(int i = 0; i < m_LSSamples; i++){
            scaledTexCoord = newTexCoord * (float(i) * factor + m_LSBlur.x) + m_LSPosition.xy;
            float depth = texture2D(m_DepthTexture, scaledTexCoord).r;

            if(depth == 1.0){
                sum += texture2D(m_Texture, scaledTexCoord);
            }
        }
        sum /= float(m_LSSamples);
        fragColor = max(fragColor, mix(fragColor, sum, m_LSDensity));
    }

    gl_FragColor = fragColor;
}
