////////////////////////////////////////////////////////////////////////////////////
/////    GeneralFilter Shader (Post Processing) for general purposes           /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

uniform sampler2D m_Texture;
uniform float m_Vibrance;
uniform float m_Hurt;
uniform float m_Sleeping;
uniform float m_Grayscale;

varying vec2 texCoord;

const vec4 coeff = vec4(0.299, 0.587, 0.114, 0.0);
const vec3 hurtColor = vec3(0.45, 0.0, 0.0);
const vec3 sleepingColor = vec3(0.0, 0.0, 0.0);

#if defined(COLORBLIND_PROTANOPIA) || defined(COLORBLIND_DEUTERANOPIA) || defined(COLORBLIND_TRITANOPIA)
    const mat3 RGBToOpponentMat3 = mat3(0.2814, -0.0971, -0.093, 0.6938, 0.1458, -0.2529, 0.0638, -0.025, 0.4665);
    const mat3 OpponentToRGBMat3 = mat3(1.1677, 0.9014, 0.7214, -6.4315, 2.597, 0.1257, -0.5044, 0.0159, 2.0517);

    const vec4 blindVisionR = vec4( 0.20,  0.99, -0.19, 0.0);
    const vec4 blindVisionG = vec4( 0.16,  0.79,  0.04, 0.0);
    const vec4 blindVisionB = vec4( 0.01, -0.01,  1.00, 0.0);
#endif

void main(){
    vec4 fragColor = texture2D(m_Texture, texCoord);
    vec2 newTexCoord = vec2(texCoord.x, texCoord.y * 2.0);

    //Tonemapping
    //fragColor.rgb = fragColor.rgb / (fragColor.rgb + 1.0) * (2.0);
    //fragColor.rgb = pow(fragColor.rgb, vec3(2.0));

    //Vibrance
    float lum = dot(fragColor, coeff);
    vec4 vib = clamp(fragColor - vec4(lum), 0.0, 1.0);
    fragColor = mix(vec4(lum), fragColor, 1.0 + m_Vibrance * (1.0 - dot(coeff, vib)));

    //Sleeping Overlay
    float distToHalfMiddle = distance(newTexCoord, vec2(0.5, 1.0));
    float sleeping = m_Sleeping * (0.25 + 2.0 * distToHalfMiddle);
    sleeping = min(1.0, sleeping);
    fragColor.rgb = mix(fragColor.rgb, sleepingColor, sleeping);

    //Damage Overlay
    float distToMiddle = distance(texCoord, vec2(0.5, 0.5));
    float hurt = m_Hurt * (2.0 * distToMiddle);
    fragColor.rgb = mix(fragColor.rgb, hurtColor, hurt);

    //Colorblind Modes
    #if defined(COLORBLIND_PROTANOPIA)
        vec3 opponent = RGBToOpponentMat3 * fragColor.rgb;
        opponent.r -= opponent.g * 1.5;
        fragColor.rgb = OpponentToRGBMat3 * opponent;
        //fragColor = vec4(dot(fragColor, blindVisionR), dot(fragColor, blindVisionG), dot(fragColor, blindVisionB), fragColor.a);
    #elif defined(COLORBLIND_DEUTERANOPIA)
        vec3 opponent = RGBToOpponentMat3 * fragColor.rgb;
        opponent.r -= opponent.g * 1.5;
        fragColor.rgb = OpponentToRGBMat3 * opponent;
        //fragColor = vec4(dot(fragColor, blindVisionR), dot(fragColor, blindVisionG), dot(fragColor, blindVisionB), fragColor.a);
    #elif defined(COLORBLIND_TRITANOPIA)
        vec3 opponent = RGBToOpponentMat3 * fragColor.rgb;
        opponent.r -= ((3.0 * opponent.b) - opponent.g) * 0.25;
        fragColor.rgb = OpponentToRGBMat3 * opponent;
        //fragColor = vec4(dot(fragColor, blindVisionR), dot(fragColor, blindVisionG), dot(fragColor, blindVisionB), fragColor.a);
    #endif

    //Grayscale Overlay
    float gray = (fragColor.r + fragColor.g + fragColor.b) / 3.0;
    vec3 grayscale = vec3(gray);
    fragColor.rgb = mix(fragColor.rgb, grayscale, m_Grayscale);
    
    gl_FragColor = fragColor; 
}
