////////////////////////////////////////////////////////////////////////////////////
/////    Player Shader for playermodels (and clothingsystem)                   /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#extension GL_EXT_gpu_shader4 : enable
#extension GL_EXT_texture_array : enable

#ifndef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform vec3 g_CameraDirection;

uniform sampler2DArray m_Textures_Array;

#ifdef DISSOLVE
    uniform sampler2D m_DissolveTexture;
    uniform float m_DissolveValue;
#endif

varying vec3 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 light;
varying vec4 texCoord;  //X=TexCoordx, Y=TexCoordy, Z=TextureLayer, W=MaskTextureLayer
varying vec4 fog;
varying vec3 color1;
varying vec3 color2;
varying vec3 color3;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    #ifdef DISSOLVE
        float dissolve = texture2D(m_DissolveTexture, texCoord.xy).r;
        if(dissolve < (1.0 - m_DissolveValue)){
            discard;
        }
    #endif

    #ifdef TEXTURES
        vec4 fragColor = texture2DArray(m_Textures_Array, texCoord.xyz);
    #else
        vec4 fragColor = vec4(1.0, 0.0, 0.0, 1.0);
    #endif

    #ifdef MASKTEXTURES
        //vec3 maskColor = texture2DArray(m_Mask_Textures_Array, texCoord.xyw).rgb;

        //Solution 1 (inaccurate, but faster)
        /*if(maskColor.r > 0.5){
            fragColor.rgb *= color1;
        }
        else if(maskColor.g > 0.5){
            fragColor.rgb *= color2;
        }
        else if(maskColor.b > 0.5){
            fragColor.rgb *= color3;
        }*/

        //Solution 2 (accurate, but slower)
        //fragColor.rgb *= mix(vec3(1.0), color1, maskColor.r);
        //fragColor.rgb *= mix(vec3(1.0), color2, maskColor.g);
        //fragColor.rgb *= mix(vec3(1.0), color3, maskColor.b);
    #endif

    //If normal-quality light is enabled: Per-Pixel-Lighting calculation (dynamic Spotlights)
    #ifndef VERTEXLIGHTING
        fragColor.rgb *= calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #else
        fragColor.rgb *= light;
    #endif
    
    #ifdef FOG
        fragColor.rgb = mix(fog.rgb, fragColor.rgb, fog.w);
    #endif
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}