////////////////////////////////////////////////////////////////////////////////////
/////    Object Shader for all objects that are placed in the world            /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#extension GL_EXT_gpu_shader4 : enable
#extension GL_EXT_texture_array : enable
#extension GL_EXT_texture_compression_dxt1 : enable
#extension GL_EXT_texture_compression_latc : enable
#extension GL_EXT_texture_compression_rgtc : enable
#extension GL_EXT_texture_compression_s3tc : enable

#import "Shaders/Lib/Selector.glsllib"

#ifndef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform vec3 g_CameraDirection;

uniform sampler2DArray m_Textures_Array;
uniform sampler2DArray m_AlphaTextures_Array;
#ifdef COLOR
    uniform vec4 m_Color;
#endif

varying vec3 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 light;
varying vec4 texCoord;  //X=TexCoordx, Y=TexCoordy, Z=TextureLayer, W=ArrayType 0:Default,1:Mask
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    #ifdef DISCARD
        discard;
    #endif

    #ifdef TEXTURES
        vec4 fragColor = vec4(0.0);
        if(texCoord.w <= 0.5){
            fragColor = texture2DArray(m_Textures_Array, texCoord.xyz);
        }
        else{
            fragColor = texture2DArray(m_AlphaTextures_Array, texCoord.xyz);
            if(fragColor.a < 0.1){
                discard;
            }
        }
        
        #ifdef COLOR
            fragColor.rgb = mix(fragColor.rgb, m_Color.rgb, m_Color.a);
        #endif
    #else
        #ifdef COLOR
            vec4 fragColor = m_Color;
        #else
            vec4 fragColor = vec4(1.0);
        #endif
    #endif

    //If normal-quality light is enabled: Per-Pixel-Lighting calculation (dynamic Spotlights)
    #ifndef VERTEXLIGHTING
        fragColor.rgb *= calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #else
        fragColor.rgb *= light;
    #endif
    
    #ifdef FOG
        fragColor.rgb = mix(fog.rgb, fragColor.rgb, fog.w);
    #endif
    
    #ifdef SELECTOR
        calculateSelector(worldpos, fragColor);
    #endif
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}