////////////////////////////////////////////////////////////////////////////////////
/////    Ore-Item Shader for all ores and resources as item                    /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#extension GL_EXT_gpu_shader4 : enable
#extension GL_EXT_texture_array : enable

#ifndef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform vec3 g_CameraDirection;

uniform sampler2DArray m_World_Textures_Array;
uniform sampler2DArray m_Ore_Textures_Array;
uniform sampler2DArray m_World_NormalMaps_Array;
uniform sampler2DArray m_Ore_NormalMaps_Array;

varying vec3 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 light;
varying vec4 texCoord;  //X=TexCoordx, Y=TexCoordy, Z=TextureLayer, W=0:World/2:Ore
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    #ifdef TEXTURES
        vec4 fragColor;
        if(texCoord.w < 0.5){
            fragColor = texture2DArray(m_World_Textures_Array, texCoord.xyz);
        }
        else{
            fragColor = texture2DArray(m_World_Textures_Array, vec3(texCoord.x, texCoord.y, 2.0));  //Stone
            vec4 ore = texture2DArray(m_Ore_Textures_Array, texCoord.xyz);
            fragColor.rgb = mix(fragColor.rgb, ore.rgb, step(0.9, ore.a));
        }
    #else
        vec4 fragColor = vec4(1.0, 0.0, 0.0, 1.0);
    #endif
    
    //If normal-quality light is enabled: Per-Pixel-Lighting calculation (dynamic Spotlights)
    #ifndef VERTEXLIGHTING
        fragColor.rgb *= calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #else
        fragColor.rgb *= light;
    #endif
    
    #ifdef FOG
        fragColor.rgb = mix(fog.rgb, fragColor.rgb, fog.w);
    #endif
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}