////////////////////////////////////////////////////////////////////////////////////
/////    Grass-Material Shader for Mesh-based Grass influenced by wind         /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#import "Shaders/Lib/Staticlighting.glsllib"
#import "Shaders/Lib/Pointlighting.glsllib"

#ifdef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif

#ifdef FOG
    #import "Shaders/Lib/Fog.glsllib"
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat3 g_NormalMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_CameraPosition;
uniform vec3 g_CameraDirection;

#ifdef WIND
    uniform float g_Time;
    #import "Shaders/Lib/Wind.glsllib"
#endif

attribute vec4 inPosition;
attribute vec3 inNormal;
attribute vec4 inColor;
attribute vec3 inTexCoord;

varying vec4 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 light;
varying vec3 texCoord;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    vec4 pos = vec4(inPosition.xyz, 1.0);
    worldpos = vec3(g_WorldMatrix * pos);

    /*
    #ifdef OCCLUSION
        if(inPosition.w >= 0.5){
            vec2 occTexCoord = vec2(worldpos.xz - g_CameraPosition.xz);
            occTexCoord -= m_OccludeOffset;
            float hx = occTexCoord.x;
            occTexCoord.x = occTexCoord.y;
            occTexCoord.y = -hx;
            occTexCoord.x += 5.0;
            occTexCoord.y += 5.0;
            occTexCoord /= 10.0;

            if(occTexCoord.x > 0 && occTexCoord.x < 1.0 && occTexCoord.y > 0.0 && occTexCoord.y < 1.0){
                float depth = texture2D(m_OccludeDepthTexture, occTexCoord).r;
                
                #ifdef LOGARITHMIC_DEPTH_BUFFER
                    depth = convertLogDepthBufferToZ(depth, g_FrustumNearFar.x, g_FrustumNearFar.y);
                #endif
                
                float occludePosition = getOcclusionPosition(depth, occTexCoord).y;
                if(worldpos.y > occludePosition){
                    pos.y -= inPosition.w;
                }
            }
        }
    #endif
    */

    #ifdef WIND
        pos.xz += getGrassWind(pos, inTexCoord);
    #endif
    
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    position = inPosition;
    normal = inNormal * 0.01;
    texCoord = inTexCoord;
    
    #ifdef FOG
        vec4 viewpos = g_WorldViewMatrix * pos;
        calculateFog(viewpos, fog);
    #endif

    //Staticlight calculation
    vec4 color = vec4(inColor.r * 0.01, inColor.g * 0.01, inColor.b * 0.01, inColor.a * 0.01);  //Color (light) ByteBuffer in Float umrechnen
    calculateStaticlight(normal, color, light, g_CameraDirection, shininess);

    //Per-Vertex-Lighting calculation (dynamic Pointlights)
    light = calculatePointlights(light, worldpos, normal, g_CameraDirection, shininess);
    
    //Optional: Per-Vertex-Lighting calculation (dynamic Spotlights)
    #ifdef VERTEXLIGHTING
        light = calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #endif
    
    //Fogcolor calculation
    //fog.xyz *= (max(color.r, color.w) * m_Sunlight.w);
}