////////////////////////////////////////////////////////////////////////////////////
/////    Grass Occlusion Pre Shader to render occluding objects                /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;

attribute vec3 inPosition;

#if defined(VEGETATION) || defined(OBJECT)
    attribute vec4 inTexCoord;
    varying vec4 texCoord;
#endif

#if defined(LOGARITHMIC_DEPTH_BUFFER)
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #if defined(LOGARITHMIC_DEPTH_BUFFER)
        positionProjectionSpace = gl_Position;
    #endif

    #if defined(VEGETATION) || defined(OBJECT)
        texCoord = inTexCoord;
    #endif
}