////////////////////////////////////////////////////////////////////////////////////
/////    Static Lighting Shader for staticlight-only influenced Objects        /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#import "Shaders/Lib/Staticlighting.glsllib"

#ifdef FOG
    #import "Shaders/Lib/Fog.glsllib"
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_WorldMatrix;
uniform mat3 g_WorldMatrixInverseTranspose;
uniform vec3 g_CameraDirection;

uniform float m_TextureScale;

attribute vec3 inPosition;
#ifdef NORMAL
    attribute vec3 inNormal;
#endif
#ifdef STATICLIGHT
    attribute vec4 inColor;
#endif
#if defined(TEXTUREARRAY) || defined(ALPHATEXTUREARRAY)
    #ifdef ALPHATEXTUREARRAY
        attribute vec4 inTexCoord;
        varying vec4 texCoord;
    #else
        attribute vec3 inTexCoord;
        varying vec3 texCoord;
    #endif
#else
    attribute vec2 inTexCoord;
    varying vec2 texCoord;
#endif

varying vec3 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 light;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    #ifdef FOG
        vec4 viewpos = g_WorldViewMatrix * pos;
        calculateFog(viewpos, fog);
    #endif
    
    position = inPosition;
    worldpos = vec3(g_WorldMatrix * pos);
    #ifdef NORMAL
        normal = normalize(g_WorldMatrixInverseTranspose * inNormal);
    #else
        normal = vec3(g_CameraDirection) * -1.0;
    #endif
    texCoord = inTexCoord * m_TextureScale;
    
    //Staticlight calculation
    #ifdef STATICLIGHT
        vec4 color = vec4(inColor.r * 0.01, inColor.g * 0.01, inColor.b * 0.01, inColor.a * 0.01);  //Color (light) ByteBuffer in Float umrechnen
    #else
        vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
    #endif
    calculateStaticlight(normal, color, light, g_CameraDirection, shininess);
    
    //Fogcolor calculation
    fog.xyz *= (color.w * m_Sunlight.w);
}