////////////////////////////////////////////////////////////////////////////////////
/////    ParticleSprite Shader for a fake particle-effect                      /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform sampler2D m_Texture;
uniform sampler2D m_MaskTexture;

uniform vec4 m_Color;

varying vec2 texCoord;
varying vec2 animationCoord;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 fragColor = texture2D(m_Texture, vec2(animationCoord));
    float mask = texture2D(m_MaskTexture, texCoord).r;
    
    if(mask < 0.01){
        discard;
    }
    
    gl_FragColor.rgb = fragColor.rgb * m_Color.rgb * mask;
    gl_FragColor.a = mask;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}